/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8275d;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8275d.BoxInfo;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class TrapCreate
implements JDMWizardPanelDelegate {
    public static final int RASID = 19;
    public static final int RASSUB = 8;
    private static ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm8275d.GeneralResources");
    protected DestinationPropBook myBook;
    protected JdmBrowser browser;
    NavigationContext myContext;
    MessageBox messageToUser;
    GenModel model;
    BoxInfo boxinfo;
    ModelInfo infoChunk;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        IPAddress iPAddress = new IPAddress("0.0.0.0");
        Hashtable hashtable = jDMWizardInfo.getItems();
        hashtable.put("trapAddress", iPAddress);
        hashtable.put("trapCommString", "");
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        this.displayMsg(TrapCreate.getNLSString("Trap_CreateAbort"));
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        Serializable serializable;
        boolean bl = true;
        IPAddress iPAddress = null;
        String string = null;
        String string2 = "proceed";
        if (RAS.isEnabled(19, 8)) {
            RAS.enter(19, 8, this, string2);
        }
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        GenModel genModel = jDMWizardInfo.getModel();
        Hashtable hashtable = jDMWizardInfo.getItems();
        if (RAS.isEnabled(19, 8)) {
            RAS.trace(19, 8, this, string2, hashtable.toString());
        }
        try {
            iPAddress = (IPAddress)hashtable.get("trapAddress");
            string = (String)hashtable.get("trapCommString");
        }
        catch (Exception exception) {
            bl = false;
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string2, "There was a problem with the user input.");
            }
            RAS.logException(19, 8, this, string2, exception);
            this.displayMsg(TrapCreate.getNLSString("Input_Exception"));
            this.messageToUser = new MessageBox(this.browser.getFrame(), TrapCreate.getNLSString("Trap_CreateError"), TrapCreate.getNLSString("Input_Exception"), true);
        }
        if (string.trim().length() == 0 || iPAddress.toString().trim().length() == 0) {
            bl = false;
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string2, "Please enter all info to create trap.");
            }
            this.displayMsg(TrapCreate.getNLSString("Trap_MissingDataError"));
            this.messageToUser = new MessageBox(this.browser.getFrame(), TrapCreate.getNLSString("Trap_CreateError"), TrapCreate.getNLSString("Trap_NeedInfoError"), true);
        }
        try {
            serializable = genModel.getRestOfInfo("Panel", "default", null, null);
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string2, "infos = " + serializable);
            }
            if (((Vector)serializable).size() >= 4) {
                bl = false;
                this.displayMsg(TrapCreate.getNLSString("Trap_MaxTraps"));
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string2, "There are already 4 traps in this table.  4 is the maximum.");
                }
                this.messageToUser = new MessageBox(this.browser.getFrame(), TrapCreate.getNLSString("Trap_CreateError"), TrapCreate.getNLSString("Trap_MaxTraps"), true);
            }
            int n = 0;
            while (n < ((Vector)serializable).size() && bl) {
                ModelInfo modelInfo = (ModelInfo)((Vector)serializable).elementAt(n);
                Serializable serializable2 = modelInfo.get("Index.TrapIp");
                modelInfo.get("Panel.TrapCommString");
                if (iPAddress.equals((IPAddress)serializable2)) {
                    if (RAS.isEnabled(19, 8)) {
                        RAS.trace(19, 8, this, string2, "duplicate!!!!");
                    }
                    bl = false;
                    this.displayMsg(TrapCreate.getNLSString("Trap_DuplicateError"));
                    if (RAS.isEnabled(19, 8)) {
                        RAS.trace(19, 8, this, string2, "This trap already exists.  Cannot create duplicate.");
                    }
                    this.messageToUser = new MessageBox(this.browser.getFrame(), TrapCreate.getNLSString("Trap_CreateError"), TrapCreate.getNLSString("Trap_DuplicateTrap"), true);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            bl = false;
            RAS.logException(19, 8, this, string2, exception);
            this.displayMsg(TrapCreate.getNLSString("Model_Error"));
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string2, "Problems getting info from the server.");
            }
            this.messageToUser = new MessageBox(this.browser.getFrame(), TrapCreate.getNLSString("Model_error"), TrapCreate.getNLSString("Model_UnknownError"), true);
        }
        if (bl) {
            serializable = new ModelInfo();
            ((ModelInfo)serializable).add("Index.TrapIp", iPAddress);
            ((ModelInfo)serializable).add("Panel.TrapStatus", new Integer(2));
            ((ModelInfo)serializable).add("Panel.TrapCommString", (Serializable)((Object)string));
            try {
                serializable = genModel.setInfo("Panel", (ModelInfo)serializable);
                bl = this.checkSnmpResponse((ModelInfo)serializable);
            }
            catch (Exception exception) {
                bl = false;
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string2, "Exception in setting model info.");
                }
                RAS.logException(19, 8, this, string2, exception);
            }
            if (!bl) {
                this.displayMsg(TrapCreate.getNLSString("Trap_SetError"));
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string2, "Problems creating trap - SNMP rejected.");
                }
                this.messageToUser = new MessageBox(this.browser.getFrame(), TrapCreate.getNLSString("Trap_CreateError"), TrapCreate.getNLSString("Trap_SetEnableError"), true);
            }
        }
        if (RAS.isEnabled(19, 8)) {
            RAS.exit(19, 8, this, string2);
        }
        return bl;
    }

    protected void displayMsg(String string) {
        if (this.browser != null) {
            this.browser.displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            try {
                string2 = myResources.getString(string);
            }
            catch (Exception exception2) {
                string2 = string;
            }
        }
        return string2;
    }

    private boolean checkSnmpResponse(ModelInfo modelInfo) {
        boolean bl = false;
        String string = "checkSnmpResponse";
        if (RAS.isEnabled(19, 8)) {
            RAS.enter(19, 8, this, string);
        }
        Enumeration enumeration = modelInfo.getItemIds();
        while (enumeration.hasMoreElements()) {
            bl = true;
            String string2 = (String)enumeration.nextElement();
            Serializable serializable = modelInfo.get(string2);
            if (!(serializable instanceof SpecialValue)) continue;
            if (RAS.isEnabled(19, 8)) {
                RAS.exit(19, 8, this, string, (Object)("Error in snmp set. Variable is " + string2 + "  SpecialValue is " + serializable));
                RAS.exit(19, 8, this, string);
            }
            bl = false;
            break;
        }
        if (RAS.isEnabled(19, 8)) {
            RAS.exit(19, 8, this, string);
        }
        return bl;
    }
}

